<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product;

use XLite\Core\Translation;
use XC\BuyButton;
use XC\MultiCurrency\Core\MultiCurrency;

/**
 * Product card content for buy button iframe
 */
class Card extends \XLite\View\AView
{
    /**
     * @var \XLite\Model\Currency
     */
    protected $previousCurrency = null;

    /**
     * Widget initialization
     */
    public function init()
    {
        if (\XLite::getController()->getCardCurrency()) {
            $this->previousCurrency = MultiCurrency::getInstance()->getSelectedCurrency();
            MultiCurrency::getInstance()->setSelectedCurrency(\XLite::getController()->getCardCurrency());
        }

        Translation::getInstance()->setTmpTranslationCode(\XLite::getController()->getCardLanguage());
        parent::init();
    }

    /**
     * @param string $template
     */
    public function display($template = null)
    {
        parent::display($template);
        Translation::getInstance()->setTmpTranslationCode(null);

        if ($this->previousCurrency && $this->previousCurrency !== MultiCurrency::getInstance()->getSelectedCurrency()) {
            MultiCurrency::getInstance()->setSelectedCurrency($this->previousCurrency);
        }
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'product/card.twig';
    }
}
