<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product;

use XCart\Extender\Mapping\Extender;
use XC\MultiCurrency\Core\MultiCurrency;

/**
 * @Extender\Mixin
 * @Extender\Depend("XC\MultiCurrency")
 */
class AttributeValuesMultiCurrency extends AttributeValues
{
    /**
     * @var \XLite\Model\Currency
     */
    protected $previousCurrency = null;

    /**
     * Widget initialization
     */
    public function init()
    {
        if (MultiCurrency::getInstance()->hasMultipleCurrencies()) {
            $this->previousCurrency = MultiCurrency::getInstance()->getSelectedCurrency();
            MultiCurrency::getInstance()->setSelectedCurrency(\XLite::getInstance()->getCurrency());
        }

        parent::init();
    }

    /**
     * @param string $template
     */
    public function display($template = null)
    {
        parent::display($template);

        if ($this->previousCurrency && $this->previousCurrency !== MultiCurrency::getInstance()->getSelectedCurrency()) {
            MultiCurrency::getInstance()->setSelectedCurrency($this->previousCurrency);
        }
    }
}
