<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product;

/**
 *
 */
class AttributeValues extends \XLite\View\Product\AttributeValues
{
    public const PARAM_ATTRIBUTE_VALUES = 'attribute_values';

    /**
     * Get product
     *
     * @return \XLite\Model\Product
     */
    protected function getProduct()
    {
        $product = parent::getProduct();
        $product->setAttrValues($this->getAttributeValues());

        return $product;
    }

    /**
     * Get order item
     *
     * @return \XLite\Model\OrderItem
     */
    protected function getOrderItem()
    {
        return $this->getParam(static::PARAM_ORDER_ITEM);
    }

    /**
     * @return array
     */
    protected function getDefaultAttributeValues()
    {
        return \XLite\Core\Request::getInstance()->attribute_values ?? '';
    }

    /**
     * Define widget params
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_ATTRIBUTE_VALUES => new \XLite\Model\WidgetParam\TypeString('Attribute values IDs', $this->getDefaultAttributeValues()),
        ];
    }

    /**
     * Return product attributes array from the request parameters
     *
     * @return array
     */
    protected function getAttributeValues()
    {
        $attributeValuesParam = $this->getParam(static::PARAM_ATTRIBUTE_VALUES);

        return $this->executeCachedRuntime(function () use ($attributeValuesParam) {
            $result          = [];

            if (is_array($attributeValuesParam)) {
                $result = $attributeValuesParam;
            } else {
                $attributeValues = trim($attributeValuesParam, ',');

                if ($attributeValues) {
                    $attributeValues = explode(',', $attributeValues);
                    foreach ($attributeValues as $attributeValue) {
                        [$attributeId, $valueId] = explode('_', $attributeValue);

                        $result[$attributeId] = $valueId;
                    }
                }
            }

            return parent::getProduct()->prepareAttributeValues($result);
        }, ['getAttributeValues', $attributeValuesParam]);
    }
}
