<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product\AttributeValue\Customer;

use XCart\Extender\Mapping\Extender;

/**
 * Attribute value (Checkbox)
 * @Extender\Mixin
 */
class Checkbox extends \XLite\View\Product\AttributeValue\Customer\Checkbox
{
    /**
     * Returns input-specific attributes
     *
     * @return array
     */
    protected function getInputAttributes()
    {
        $attributes = parent::getInputAttributes();

        if (\XLite::getController()->getTarget() == 'buy_button_configure') {
            $attrValues = $this->getAttrValues();

            $attributes = array_merge(
                $attributes,
                [
                    'v-bind:true-value' => $attrValues[1]->getId(),
                    'v-bind:false-value' => $attrValues[0]->getId(),
                ]
            );
        }

        return $attributes;
    }
}
