<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product\AttributeValue\Customer;

use XCart\Extender\Mapping\Extender;

/**
 * Abstract attribute value (customer)
 * @Extender\Mixin
 */
abstract class ACustomer extends \XLite\View\Product\AttributeValue\Customer\ACustomer
{
    /**
     * Returns input-specific attributes
     *
     * @return array
     */
    protected function getInputAttributes()
    {
        $attributes = parent::getInputAttributes();

        if (\XLite::getController()->getTarget() == 'buy_button_configure') {
            $attributes['v-model'] = 'attrs[' . $this->getAttribute()->getId() . ']';
        }

        return $attributes;
    }
}
