<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View;

use XCart\Extender\Mapping\Extender;

/**
 * Class Price
 * @Extender\Mixin
 * @Extender\Depend ("CDev\VAT")
 */
class Price extends \XLite\View\Price
{
    /**
     * Determine if we need to display 'incl.VAT' note
     *
     * @return boolean
     */
    protected function isVATApplicable()
    {
        if (in_array($this->getTarget(), $this->getBuyButtonTargets(), true)) {
            return false;
        }

        return parent::isVATApplicable();
    }

    /**
     * @return array
     */
    protected function getBuyButtonTargets()
    {
        return [ 'buy_button' ];
    }
}
