<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Menu\Admin;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class LeftMenu extends \XLite\View\Menu\Admin\LeftMenu
{
    /**
     * @param array $params Handler params OPTIONAL
     */
    public function __construct(array $params = [])
    {
        if (!isset($this->relatedTargets['buy_button'])) {
            $this->relatedTargets['buy_button'] = [];
        }

        $this->relatedTargets['buy_button'][] = 'buy_button_configure';

        parent::__construct();
    }

    /**
     * @return array
     */
    protected function defineItems()
    {
        $list = parent::defineItems();

        $list['promotions'][self::ITEM_CHILDREN]['buy_button'] = [
            self::ITEM_TITLE      => static::t('Buy Button'),
            self::ITEM_TARGET     => 'buy_button',
            self::ITEM_CLASS      => 'buy-button',
            self::ITEM_PERMISSION => 'ROLE_MANAGE_CATALOG',
            self::ITEM_WEIGHT     => 500,
        ];

        return $list;
    }
}
