<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\ItemsList\Model;

use XC\BuyButton;

/**
 * Product selections items list
 */
class ProductChooser extends \XLite\View\ItemsList\Model\ProductSelection
{
    /**
     * @return array
     */
    public function getCSSFiles()
    {
        return [
            BuyButton\Main::getSkinDir() . 'product_chooser/style.css'
        ];
    }

    /**
     * Return wrapper form options
     *
     * @return string
     */
    protected function getFormOptions()
    {
        $options = parent::getFormOptions();

        $options['class'] = 'XC\BuyButton\View\Form\ItemsList\ProductChooser\Table';
        $options['target'] = null;
        $options['action'] = null;
        $options['params'] = [
            'mode' => \XLite::getController()->getConfigurationMode()
        ];

        return $options;
    }

    /**
     * Get switcher field
     *
     * @return array
     */
    protected function getSwitcherField()
    {
        return [];
    }

    /**
     * Define columns structure
     *
     * @return array
     */
    protected function defineColumns()
    {
        return [
            'sku' => [
                static::COLUMN_NAME    => \XLite\Core\Translation::lbl('SKU'),
                static::COLUMN_SORT    => static::SORT_BY_SKU,
                static::COLUMN_NO_WRAP => true,
                static::COLUMN_ORDERBY  => 100,
                static::COLUMN_MAIN    => false,
            ],
            'name' => [
                static::COLUMN_NAME    => \XLite\Core\Translation::lbl('Name'),
                static::COLUMN_SORT    => static::SORT_BY_NAME,
                static::COLUMN_NO_WRAP => true,
                static::COLUMN_ORDERBY  => 200,
                static::COLUMN_MAIN    => true,
            ],
            'price' => [
                static::COLUMN_NAME     => \XLite\Core\Translation::lbl('Price'),
                static::COLUMN_TEMPLATE => 'product_selections/parts/info.price.twig',
                static::COLUMN_SORT     => static::SORT_BY_PRICE,
                static::COLUMN_ORDERBY  => 300,
            ],
        ];
    }

    /**
     * Mark list as switchable (enable / disable)
     *
     * @return boolean
     */
    protected function isSwitchable()
    {
        return false;
    }

    /**
     * Mark list as selectable
     *
     * @return boolean
     */
    protected function isSelectable()
    {
        return false;
    }

    /**
     * Get left actions tempaltes
     *
     * @return array
     */
    protected function getLeftActions()
    {
        $list = parent::getLeftActions();
        $list[] = $this->getSelectorActionTemplate();

        return $list;
    }

    /**
     * Template for selector action definition
     *
     * @return string
     */
    protected function getSelectorActionTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'product_chooser/selector.twig';
    }

    /**
     * Returns selector link
     *
     * @param integer $id Entity id
     *
     * @return string
     */
    protected function getSelectorUrl($id)
    {
        return $id
            ? $this->buildURL(
                'buy_button_configure',
                '',
                ['product_id' => $id, 'mode' => \XLite::getController()->getConfigurationMode()]
            )
            : '';
    }

    /**
     * getURLParams
     *
     * @return array
     */
    protected function getCommonParams()
    {
        return array_merge(
            parent::getCommonParams(),
            [
                'mode' => \XLite::getController()->getConfigurationMode()
            ]
        );
    }

    /**
     * Get container class
     *
     * @return string
     */
    protected function getContainerClass()
    {
        return parent::getContainerClass() . ' product_chooser';
    }

    /**
     * Return class name for the list pager
     *
     * @return string
     */
    protected function getPagerClass()
    {
        return 'XLite\View\Pager\Admin\Model\ProductSelection\Table';
    }

    /**
     * Check - sticky panel is visible or not
     *
     * @return boolean
     */
    protected function isPanelVisible()
    {
        return false;
    }

    /**
     * Get panel class
     *
     * @return \XLite\View\Base\FormStickyPanel
     */
    protected function getPanelClass()
    {
        return 'XLite\View\StickyPanel\ItemsList\ProductSelection';
    }
}
