<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View;

use XCart\Extender\Mapping\ListChild;
use XC\BuyButton;

/**
 * Top menu widget
 *
 * @ListChild (list="admin.center", zone="admin")
 */
class IntroPage extends \XLite\View\AView
{
    /**
     * Return list of allowed targets
     * This widget is displayed only on the featured product selector
     *
     * @return array
     */
    public static function getAllowedTargets()
    {
        return ['buy_button'];
    }

    /**
     * @return array
     */
    public function getCSSFiles()
    {
        return [
            [
                'file'  => BuyButton\Main::getSkinDir() . 'style.less',
                'media' => 'screen',
                'merge' => 'bootstrap/css/bootstrap.less',
            ],
        ];
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'intro.twig';
    }
}
