<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\FormField\Select;

use XLite\Core\Database;

/**
 * Product card language (available starting from v1 api)
 */
class Language extends \XLite\View\FormField\Select\Regular
{
    public const OPTION_STORE_DEFAULT = 'default';
    public const OPTION_CUSTOMER_SESSION = 'session';

    /**
     * getDefaultLabel
     *
     * @return string
     */
    protected function getDefaultLabel()
    {
        return 'Card language';
    }

    /**
     * getDefaultValue
     *
     * @return string
     */
    protected function getDefaultValue()
    {
        return static::OPTION_CUSTOMER_SESSION;
    }

    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        $return = [
            static::OPTION_CUSTOMER_SESSION => static::t('Customer session language'),
            static::OPTION_STORE_DEFAULT => static::t('Default for customers')
        ];

        foreach (Database::getRepo('\XLite\Model\Language')->findActiveLanguages() as $language) {
            $return[$language->getCode()] = $language->getName();
        }

        return $return;
    }
}
