<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\FormField\Select\Currency;

use XCart\Extender\Mapping\Extender;

/**
 * Customer currency selector
 *
 * @Extender\Mixin
 * @Extender\Depend({"XC\MultiCurrency","XC\Geolocation"})
 */
class CustomerCurrencyGeolocation extends \XC\MultiCurrency\View\FormField\Select\Currency\CustomerCurrency
{
    public const OPTION_STORE_DEFAULT = 'default';

    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        $options = parent::getDefaultOptions();

        $options[static::OPTION_STORE_DEFAULT] = static::t('Currency by geolocation');

        return $options;
    }
}
