<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\FormField\Select\Currency;

use XCart\Extender\Mapping\Extender;
use XC\BuyButton\Controller\IBuyButtonScope;

/**
 * Customer currency selector
 *
 * @Extender\Mixin
 * @Extender\Depend("XC\MultiCurrency")
 */
class CustomerCurrency extends \XC\MultiCurrency\View\FormField\Select\Currency\CustomerCurrency
{
    public const OPTION_STORE_DEFAULT = 'default';

    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        return array_merge([
            static::OPTION_STORE_DEFAULT => static::t('Default for customers')
        ], parent::getDefaultOptions());
    }

    /**
     * Return field value
     *
     * @return mixed
     */
    public function getValue()
    {
        if (\XLite::getController() instanceof IBuyButtonScope) {
            return static::OPTION_STORE_DEFAULT;
        }

        return parent::getValue();
    }
}
