<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Button;

use XC\BuyButton;

/**
 * Product selection in popup
 */
class EmbedProduct extends \XLite\View\Button\PopupProductSelector
{
    public const PARAM_MODE = 'mode';

    /**
     * Define widget parameters
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_MODE          => new \XLite\Model\WidgetParam\TypeString('Output mode', 'card'),
        ];
    }

    /**
     * Defines the target of the product selector
     * The main reason is to get the title for the selector from the controller
     *
     * @return string
     */
    protected function getSelectorTarget()
    {
        return 'buy_button_product_chooser';
    }

    /**
     * Defines the class name of the widget which will display the product list dialog
     *
     * @return string
     */
    protected function getSelectorViewClass()
    {
        return 'XC\BuyButton\View\ProductChooser';
    }

    /**
     * getDefaultLabel
     *
     * @return string
     */
    protected function getDefaultLabel()
    {
        return 'Select product';
    }

    /**
     * Return URL parameters to use in AJAX popup
     *
     * @return array
     */
    protected function prepareURLParams()
    {
        return array_merge(
            parent::prepareURLParams(),
            [
                'mode' => $this->getParam(self::PARAM_MODE)
            ]
        );
    }

    protected function getDefaultTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'button/popup_button.twig';
    }
}
