<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Model;

use XCart\Extender\Mapping\Extender;

/**
 * Product
 *
 * @Extender\Mixin
 * @Extender\Depend("XC\ProductVariants")
 */
abstract class Product extends \XLite\Model\Product
{
    /**
     * Get default variant
     *
     * @return mixed
     */
    public function getDefaultVariant()
    {
        return parent::getDefaultVariant();
    }

    /**
     * Parses attribute values string and return key-value array of attributes
     *
     * @param $attributeValues
     * @return array
     */
    public static function parseAttributeValueIds($attributeValues)
    {
        $ids = [];

        if ($attributeValues) {
            $attributeValues = explode(',', $attributeValues);
            foreach ($attributeValues as $v) {
                if ($v) {
                    $v = explode('_', $v);
                    $ids[$v[0]] = $v[1];
                }
            }
        }

        return $ids;
    }

    /**
     * Get image
     *
     * @return \XLite\Model\Image\Product\Image
     */
    public function getImage()
    {
        if (
            \XLite::getController() instanceof \XC\BuyButton\Controller\IBuyButtonScope
            && $this->isUseVariantImage()
        ) {
            $attrs = \XLite\Core\Request::getInstance()->attribute_values;

            if (!is_array($attrs)) {
                $attrs = static::parseAttributeValueIds($attrs);
            }

            $variant = $this->getVariantByAttributeValuesIds($attrs);
            if ($variant) {
                return $variant->getImage();
            } elseif ($this->getDefaultVariant()) {
                return $this->getDefaultVariant()->getImage();
            }
        }

        return parent::getImage();
    }

    /**
     * Return true if variant image should be used instead of default product image
     *
     * @return boolean
     */
    protected function isUseVariantImage()
    {
        if (
            \XLite::getController() instanceof \XC\BuyButton\Controller\IBuyButtonScope
            && $this->mustHaveVariants()
            && $this->hasVariants()
        ) {
            $attrs = \XLite\Core\Request::getInstance()->attribute_values;

            if (!is_array($attrs)) {
                $attrs = static::parseAttributeValueIds($attrs);
            }

            $variant = $this->getVariantByAttributeValuesIds($attrs);

            return ($variant && $variant->getImage()) || ($this->getDefaultVariant() && $this->getDefaultVariant()->getImage());
        }

        return parent::isUseVariantImage();
    }
}
