<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Core;

/**
 * API
 */
class APIFactory
{
    /**
     * Create printer
     *
     * @return \XC\BuyButton\Core\API\V1
     */
    public static function create($version, $request)
    {
        $schema = null;
        foreach (static::getAPIVersions() as $class) {
            if ($class::isApplicable($version)) {
                $schema = new $class($request);
                break;
            }
        }

        return $schema;
    }

    /**
     * Get schema classes
     * TODO: Infer from classes inside API folder.
     *
     * @return array
     */
    protected static function getAPIVersions()
    {
        return [
            'XC\BuyButton\Core\API\V1',
        ];
    }

    // }}}
}
