<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Core\API;

use XC\BuyButton\Core\API;
use XC\BuyButton\View\Product\Card;

/**
 * Buy Button common API class
 */
class V1 extends API
{
    public const CODE = 'v1';

    /**
     * Check - schema is own this request or not
     *
     * @param string $version
     *
     * @return boolean
     */
    public static function isApplicable($version)
    {
        return trim(strtolower($version)) == strtolower(static::CODE);
    }

    /**
     * Returns some output on the request
     *
     * @return string
     */
    public function processRequest()
    {
        $widget = new Card();
        $widget->init();
        return $widget->getContent();
    }
}
