<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Core;

/**
 * Buy Button common API class
 */
abstract class API
{
    /**
     * Constructor
     *
     * @param \XLite\Core\Request $request Request
     */
    public function __construct(\XLite\Core\Request $request)
    {
        $this->request = $request;
    }

    /**
     * Check - can schema process this request or not
     *
     * @param string $version
     *
     * @return boolean
     */
    public static function isApplicable($version)
    {
        return false;
    }

    /**
     * Check if API should return 403 error
     *
     * @return boolean
     */
    public function isForbid()
    {
        return false;
    }

    /**
     * Get config
     *
     * @return \ArrayObject
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * Does the actual work
     *
     * @return string
     */
    abstract public function processRequest();
}
