<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Controller\Customer;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;

/**
 * BuyButton public API controller
 * @Extender\Mixin
 */
abstract class Cart extends \XLite\Controller\Customer\Cart
{
    /**
     * URL to return after product is added
     *
     * @return string
     */
    protected function getURLToReturn()
    {
        if (Request::getInstance()->bb_return && Request::getInstance()->returnURL) {
            return Request::getInstance()->returnURL;
        }

        return parent::getURLToReturn();
    }

    /**
     * Check - need to redirect
     *
     * @return boolean
     */
    public function checkLanguage()
    {
        if (Request::getInstance()->bb_return) {
            return true;
        }

        return parent::checkLanguage();
    }
}
