<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Controller\Customer;

use XC\BuyButton\Controller\Features\BuyButtonProviderTrait;
use XC\BuyButton\Controller\IBuyButtonScope;
use XC\BuyButton\Core\APIFactory;
use XC\BuyButton\Core\Printer;

/**
 * BuyButton public API controller
 */
class BuyButton extends \XLite\Controller\Customer\Product implements IBuyButtonScope
{
    use BuyButtonProviderTrait;

    /**
     * API runtime cache
     * @var \XC\BuyButton\Core\API
     */
    protected $api;

    /**
     * Process request
     *
     * @return void
     */
    public function processRequest()
    {
    }

    /**
     * Mark controller run thread as access denied
     *
     * @return void
     */
    protected function markAsAccessDenied()
    {
        if ($this->getAPI() && $this->getAPI()->isForbid()) {
            header('HTTP/1.0 403 Forbidden', true, 403);
        } else {
            header('HTTP/1.0 404 Not Found', true, 404);
        }

        $this->setSuppressOutput(true);
        $this->silent = true;
    }

    /**
     * Preprocessor for no-action run
     *
     * @return void
     */
    protected function doNoAction()
    {
        try {
            $data = $this->getAPI()->processRequest();
        } catch (\Exception $e) {
            header('HTTP/1.0 400 Bad Request', true, 400);
            header('X-API-Error: ' . $e->getMessage());
            \XLite\Logger::getInstance()->registerException($e);
            $data = null;
        }

        $this->silent = true;
        $this->setSuppressOutput(true);
        $this->getPrinter()->printOutput($data);
    }

    /**
     * Get schema
     *
     * @return \XC\BuyButton\Core\API
     */
    public function getAPI()
    {
        if (
            !isset($this->api)
            || !($this->api instanceof \XC\BuyButton\Core\API)
        ) {
            $request = \XLite\Core\Request::getInstance();

            $this->api = APIFactory::create(
                $request->api,
                $request
            );
        }

        return $this->api;
    }

    /**
     * Get schema
     *
     * @return Printer
     */
    public function getPrinter()
    {
        if (!isset($this->printer)) {
            $this->printer = new Printer();
        }

        return $this->printer;
    }
}
