<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Controller\Customer;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;
use XC\MultiCurrency\Controller\Customer\ChangeCurrency;
use XC\MultiCurrency\Core\MultiCurrency;

/**
 * BuyButton public API controller
 *
 * @Extender\Mixin
 * @Extender\Depend("XC\MultiCurrency")
 */
abstract class ACustomerMultiCurrency extends \XLite\Controller\Customer\ACustomer
{
    /**
     * Change current language
     *
     * @return void
     */
    public function handleRequest()
    {
        if (Request::getInstance()->currency && !(\XLite::getController() instanceof ChangeCurrency)) {
            $code = Request::getInstance()->currency;
            /** @var \XC\MultiCurrency\Model\ActiveCurrency $active */
            $active = \XLite\Core\Database::getRepo('XC\MultiCurrency\Model\ActiveCurrency')->getCurrencyByCode($code);
            if ($active) {
                MultiCurrency::getInstance()->setSelectedCurrency($active->getCurrency());
            }
        }

        parent::handleRequest();
    }
}
