<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Controller\Customer;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;
use XLite\Core\Session;

/**
 * BuyButton public API controller
 * @Extender\Mixin
 */
abstract class ACustomer extends \XLite\Controller\Customer\ACustomer
{
    /**
     * Change current language
     *
     * @return void
     */
    public function handleRequest()
    {
        if (Request::getInstance()->force_lang) {
            $code = Request::getInstance()->force_lang;
            $language = \XLite\Core\Database::getRepo('\XLite\Model\Language')->findOneByCode($code);

            if (isset($language) && $language->getEnabled()) {
                Session::getInstance()->setLanguage($language->getCode());

                $url = preg_replace('/(&?force_lang=\w+)(&?)/i', '$2', \XLite\Core\URLManager::getCurrentURL());
                $this->setReturnURL($url);
            }
        }

        parent::handleRequest();
    }
}
