<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Controller\Admin;

/**
 * Subscribers controller
 */
class BuyButtonProductChooser extends \XLite\Controller\Admin\ProductSelections
{
    /**
     * Check if the product id which will be displayed as "Already added"
     *
     * @param int $productId
     * @return bool
     */
    public function isExcludedProductId($productId)
    {
        /** @var \XLite\Model\Product $product */
        $product = \XLite\Core\Database::getRepo('XLite\Model\Product')->find($productId);

        return $product && !$product->getEnabled();
    }

    /**
     * Specific title for the excluded product
     *
     * @param integer $productId Product ID
     *
     * @return string
     */
    public function getTitleExcludedProduct($productId)
    {
        return static::t('This product is disabled');
    }

    /**
     * Specific CSS class for the image of the excluded product.
     * You can check the Font Awesome CSS library if you want some specific icons
     *
     * @param integer $productId
     *
     * @return string
     */
    public function getStyleExcludedProduct($productId)
    {
        return 'fa-ban';
    }

    /**
     * Return the current page title (for the content area)
     *
     * @return string
     */
    public function getTitle()
    {
        return static::t('Choose a product to create Buy Button');
    }

    /**
     * Possible values are 'card', 'email'
     * @return string
     */
    public function getConfigurationMode()
    {
        return \XLite\Core\Request::getInstance()->mode ?? 'card';
    }
}
