<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\Controller\Admin;

use XC\BuyButton\Controller\Features\BuyButtonProviderTrait;

/**
 * Subscribers controller
 */
class BuyButtonConfigure extends \XLite\Controller\Admin\Product implements \XC\BuyButton\Controller\IBuyButtonScope
{
    use BuyButtonProviderTrait;

    /**
     * Return the current page title (for the content area)
     *
     * @return string
     */
    public function getTitle()
    {
        return static::t('Configure buy button');
    }

    // {{{ Pages

    /**
     * Get pages sections
     *
     * @return array
     */
    public function getPages()
    {
        return [];
    }

    /**
     * Get pages templates
     *
     * @return array
     */
    protected function getPageTemplates()
    {
        return [];
    }


    /**
     * Possible values are 'card', 'email'
     * @return string
     */
    public function getConfigurationMode()
    {
        return \XLite\Core\Request::getInstance()->mode ?? 'card';
    }

    // }}}
}
