/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Embeddable
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

(function () {
var XCartBuy = function() {
}

XCartBuy.prototype.init = function(params) {
    var container = document.getElementById(params.container);
    var iframe = document.createElement('iframe');
    iframe.style.width = String(params.width) + "px";
    iframe.style.height = String(params.height) + "px";
    iframe.src = this.buildSrc(params);
    iframe.setAttribute('horizontalscrolling', "no");
    iframe.setAttribute('verticalscrolling', "no");
    iframe.setAttribute('allowtransparency', "true");
    iframe.setAttribute('frameborder', "0");
    iframe.setAttribute('scrolling', "no");
    container.style.display = "inline-block";
    container.appendChild(iframe);
}

XCartBuy.prototype.buildSrc = function(params) {
    var result = params.url;
    var attrs = params.query.attribute_values;
    delete params.query.attribute_values;

    for (var key in params.query) {
        result += '&' + encodeURIComponent(key) + '=' + encodeURIComponent(params.query[key]);
    }

    for (var key in attrs) {
        result += '&' + 'attribute_values[' + key + ']' + '=' + encodeURIComponent(attrs[key]);
    }

    return result;
}

window.XCartBuy = new XCartBuy();
})();