/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('buy_button/preview', ['js/vue/vue', 'vue/vue.loadable'], function (XLiteVue, VueLoadableMixin) {

  XLiteVue.component('xlite-product-preview', {
    props: ['params'],

    mixins: [VueLoadableMixin],

    loadable: {
      loader: function () {
        assignWaitOverlay($(this.$el));
        return xcart.get(
          _.extend({
            target: 'buy_button_configure',
            widget: 'XC\\BuyButton\\View\\Product\\Preview',
          }, this.params)
          , undefined, undefined, { timeout: 45000 }
        );
      },

      resolve: function () {
        var self = this;
        this.$nextTick(function () {
          self.writeIframe();
          unassignWaitOverlay($(self.$el));
        });
      },

      reject: function () {
        var self = this;
        this.$nextTick(function () {
          unassignWaitOverlay($(self.$el));
        });
      }
    },

    ready: function () {
      var self = this;
      _.defer(function () {
        self.writeIframe();
      });
    },

    computed: {
      classes: function () {
        return {
          'reloading': this.$reloading,
        }
      },
    },

    watch: {
      params: function() {
        if (!this.firstTimeCheck) {
          this.firstTimeCheck = true;
        } else {
          this.$reload();
        }
      }
    },

    methods: {
      writeIframe: function () {
        var ifrm = document.getElementById('product-preview-frame');
        var template = document.getElementById('product-preview-template');
        ifrm = ifrm.contentWindow || ifrm.contentDocument.document || ifrm.contentDocument;
        ifrm.document.open();
        ifrm.document.write(template.innerHTML);
        ifrm.document.close();
      }
    },

  });

});
