/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('buy_button/configuration_start', ['js/vue/vue', 'ready'], function (XLiteVue) {

  Vue.directive('data', {
    inserted: function (el, binding) {
      var vm = Vue.getClosestVueInstance(el);

      if (!vm) {
        return;
      }

      var object = binding.value;
      for (var key in object) {
        vm[key] = object[key];
      }
    }
  });
});

define('buy_button/configuration', ['js/vue/vue'], function (XLiteVue) {

  XLiteVue.component('xlite-buy-button-configuration', {
    props: ['panelParams'],

    ready: function () {
      this.triggerInputChange();
    },

    data: function () {
      return _.extend({
        product: null,
        mode: null,
        attrs: this.getAttributes(),
      }, this.convertToObject(this.panelParams));
    },

    methods: {
      getAttributes: function () {
        let attrs = {};
        $('ul.attribute-values select option:selected').each(function() {
          attrs[$(this).parent().data('attribute-id')] = $(this).val();
        });
        return attrs;
      },
      convertToObject: function (params) {
        return params.reduce(function(obj, param){
          var value;

          switch (param) {
            case 'click_action':
              value = 'details';
              break;

            case 'language':
              value = 'session';
              break;

            default:
              value = null;
          }

          obj[param] = value;

          return obj;
        }, {})
      },

      triggerInputChange: function () {
        document.querySelectorAll('ul.attribute-values input').forEach(function(item) {
          item.fireEvent('change');
        });
      },

      getParams: function () {
        return this.buildParamsObject();
      },

      generateCode: function () {
        popup.open(this.renderPopup({
          title: 'Embed this code to your website',
          content: $('#code-template').val()
        }));
      },

      generateLink: function () {
        popup.open(this.renderPopup({
          title: 'Insert this link to your email',
          content: $('#link-template').text().trim()
        }));
      },

      renderPopup: function (options) {
        $('.generate-code-popup').remove();
        var popup = $('#popup-template').clone();
        popup.attr('id', '');
        popup.data('title', xcart.t(options.title));
        popup.data('dialog-class', 'generate-code-popup');
        popup.find('[data-source]').val(options.content).attr('id', 'embed-code');
        xcart.autoload(ClipboardButton, popup.find('.copy-link'));
        popup.find('[data-source]').get(0).focus();
        popup.find('[data-source]').get(0).setSelectionRange(0, 0);
        popup.removeClass('hidden');
        return popup;
      },

      defineGenericParams: function () {
        var self = this;

        var panelParams = this.panelParams.reduce(function (obj, param) {
            obj[param] = self[param];
            return obj;
        }, {});

        return _.extend({
            'product_id': this.product,
            'mode': this.mode
        }, panelParams);
      },

      buildParamsObject: function () {
        var params = this.defineGenericParams();

        for (key in this.attrs) {
          params['attribute_values[' + key + ']'] = this.attrs[key];
        }

        return params;
      },

      getAttributesString: function () {
        var attrs = this.attrs;
        return Object.keys(attrs).reduce(function(acc, key) {
            acc = acc + String(key) + '_' + String(attrs[key]) + ',';
            return acc;
        }, '');
      }
    }
  });

});
