<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BulkEditing\View\RemoveProducts;

use XLite;
use XC\BulkEditing\Logic\RemoveProducts\Generator;
use XLite\Model\WidgetParam\TypeString;
use XLite\View\AView;
use XLite\View\EventTaskProgressProviderTrait;

class Progress extends AView
{
    use EventTaskProgressProviderTrait;

    public const PARAM_RETURN_URL = 'returnURL';

    protected function defineWidgetParams(): void
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_RETURN_URL => new TypeString('Return URL')
        ];
    }

    protected function getReturnUrl(): string
    {
        return (string)$this->getParam(static::PARAM_RETURN_URL);
    }

    protected function getDefaultTemplate(): string
    {
        return 'modules/XC/BulkEditing/remove_products/progress.twig';
    }

    protected function getProcessor(): Generator|bool
    {
        return XLite::getController()->getRemoveProductsGenerator();
    }

    public function getJSFiles(): array
    {
        $list = parent::getJSFiles();
        $list[] = 'modules/XC/BulkEditing/remove_products/controller.js';

        return $list;
    }
}
