<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BulkEditing\View\Popup;

use XC\BulkEditing\Logic\RemoveProducts\Generator;
use XLite\Model\WidgetParam\TypeInt;
use XLite\Model\WidgetParam\TypeString;
use XLite\View\AView;

class RemoveProducts extends AView
{
    public const PARAM_RETURN_URL = 'returnUrl';

    public const PARAM_LIST_WIDGET = 'listWidget';

    public const PARAM_SELECTED_COUNT = 'selectedCount';

    protected function getDefaultTemplate(): string
    {
        return 'modules/XC/BulkEditing/popup/remove_products/body.twig';
    }

    public function getJSFiles(): array
    {
        $list = parent::getJSFiles();
        $list[] = 'event_task_progress/controller.js';
        $list[] = 'modules/XC/BulkEditing/remove_products/controller.js';

        return $list;
    }

    protected function defineWidgetParams(): void
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_RETURN_URL     => new TypeString('Return URL'),
            static::PARAM_LIST_WIDGET    => new TypeString('List Widget FQN'),
            static::PARAM_SELECTED_COUNT => new TypeInt('Selected products count')
        ];
    }

    protected function getSelectedCount(): int
    {
        return (int)$this->getParam(static::PARAM_SELECTED_COUNT);
    }

    protected function getReturnUrl(): string
    {
        return (string)($this->getParam(static::PARAM_RETURN_URL));
    }

    protected function getListWidgetFqn(): string
    {
        return (string)($this->getParam(static::PARAM_LIST_WIDGET));
    }

    protected function getProductsCountToRemove(): int
    {
        return $this->getSelectedCount() ?: Generator::getTotalProductsCount($this->getListWidgetFqn());
    }
}
