<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BulkEditing\View\Popup;

use XC\BulkEditing\Logic\RemoveProducts\Generator;
use XCart\Extender\Mapping\ListChild;
use XLite\View\Popup\AutoPopup;

/**
 * @ListChild (list="admin.center", zone="admin", weight=1000)
 */
class AutoPopupRemoveProducts extends AutoPopup
{
    /**
     * @return string[]
     */
    public static function getAllowedTargets(): array
    {
        $targets = parent::getAllowedTargets();
        $targets[] = 'bulk_remove_products';

        return $targets;
    }

    protected function getInnerWidgetClass(): string
    {
        return RemoveProducts::class;
    }

    protected function getPopupParams(): array
    {
        $params = parent::getPopupParams();
        $params['closeOnEscape'] = false;

        return $params;
    }

    protected function isVisible(): bool
    {
        return parent::isVisible()
            && Generator::isInProgress('XLite\View\ItemsList\Model\Product\Admin\Search');
    }
}
