<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BulkEditing\View\Form\RemoveProducts;

use XLite\Controller\AController;
use XLite\Model\WidgetParam\TypeString;
use XLite\View\Form\AForm;

class Confirm extends AForm
{
    public const PARAM_RETURN_URL = 'returnUrl';
    public const PARAM_LIST_WIDGET = 'listWidget';

    protected function defineWidgetParams(): void
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_RETURN_URL  => new TypeString('Return URL'),
            static::PARAM_LIST_WIDGET => new TypeString('List widget FQN')
        ];
    }

    protected function getReturnUrl(): string
    {
        return (string)($this->getParam(static::PARAM_RETURN_URL));
    }

    protected function getListWidget(): string
    {
        return (string)($this->getParam(static::PARAM_LIST_WIDGET));
    }

    protected function getDefaultTarget(): string
    {
        return 'bulk_remove_products';
    }

    protected function getDefaultAction(): string
    {
        return 'start';
    }

    protected function getFormParams(): array
    {
        $params = parent::getFormParams();

        if ($listWidget = $this->getListWidget()) {
            $params['listWidget'] = $listWidget;
        }

        if ($returnUrl = $this->getReturnUrl()) {
            $params[AController::RETURN_URL] = $returnUrl;
        }

        return $params;
    }
}
