<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BulkEditing\View\Button;

/**
 * ItemsExport button
 */
class Product extends ABulkEdit
{
    /**
     * @return array
     */
    protected function getScenarios()
    {
        return [
            'product_categories'           => [
                'position' => 100,
            ],
            'product_inventory'            => [
                'position' => 200,
            ],
            'product_price_and_membership' => [
                'position' => 300,
            ],
            'product_shipping_info'        => [
                'position' => 400,
            ],
            'product_hidden_attributes'    => [
                'position' => 500,
            ],
            // 'product_global_attributes'    => [
            //     'position' => 500,
            // ],
        ];
    }

    protected function defineAdditionalButtons()
    {
        $result = [];

        $scenarios = \XC\BulkEditing\Logic\BulkEdit\Scenario::getScenarios();
        $availableScenarios = $this->getScenarios();

        foreach ($availableScenarios as $name => $options) {
            $data = $scenarios[$name] ?? [];
            if (!$data) {
                continue;
            }

            if (isset($data['url'])) {
                $result[$name] = [
                    'class'    => 'XC\BulkEditing\View\Button\ComingSoon',
                    'params'   => [
                        'label'    => $data['title'],
                        'location' => $data['url'],
                        'blank'    => true,
                        'style'    => 'always-enabled action link list-action',
                    ],
                    'position' => $options['position'],
                ];
            } else {
                $result[$name] = [
                    'params'   => [
                        'label'      => $data['title'],
                        'action'     => 'start',
                        'formParams' => ['target' => 'bulk_edit', 'scenario' => $name],
                        'style'      => 'always-enabled action link list-action',
                    ],
                    'position' => $options['position'],
                ];
            }
        }

        $result['remove_products'] = [
            'class'    => PopupRemoveProducts::class,
            'params'   => [
                'label' => static::t('Delete'),
                'style' => 'always-enabled link list-action remove-products',
            ],
            'position' => PHP_INT_MAX
        ];

        return $result;
    }
}
