<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BulkEditing\View\Button;

use XLite;
use XLite\View\Button\APopupButton;
use XC\BulkEditing\View\Popup\RemoveProducts;

class PopupRemoveProducts extends APopupButton
{
    public function getJSFiles(): array
    {
        $list = parent::getJSFiles();
        $list[] = 'modules/XC/BulkEditing/button/remove-products.js';

        return $list;
    }

    public function getCSSFiles(): array
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/XC/BulkEditing/remove_products/style.less';

        return $list;
    }

    protected function prepareURLParams(): array
    {
        return [
            'target'     => 'bulk_remove_products',
            'widget'     => RemoveProducts::class,
            'returnUrl'  => XLite::getController()->getURL()
        ];
    }

    protected function getClass(): string
    {
        return trim(parent::getClass() . ' popup-remove-products always-reload');
    }

    protected function getDefaultLabel(): string
    {
        return 'Delete';
    }
}
