<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\BulkEditing\Core\TranslationLanguage;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Translation;

/**
 * @Extender\Mixin
 */
class ATranslationLanguage extends \XLite\Core\TranslationLanguage\ATranslationLanguage
{
    protected function defineLabelHandlers()
    {
        return parent::defineLabelHandlers() + [
            'Products deletion cancelled. X products out of Y have been deleted'                     => 'XProductsOutOfYHaveBeenDeleted',
            'X products have been deleted.'                                                          => 'XProductsHaveBeenDeleted',
            'This action will delete X products from your store. Are you sure you want to continue?' => 'ThisActionWillDeleteXProductsFromYourStore',
        ];
    }

    /**
     * Label: 'Products deletion cancelled. X products out of Y have been deleted'
     */
    public function translateLabelXProductsOutOfYHaveBeenDeleted(array $arguments)
    {
        $label = $this->getLabelByRule(
            [
                'Products deletion cancelled. X product out of Y has been deleted',
                'Products deletion cancelled. X products out of Y have been deleted',
            ],
            $arguments['removed_products']
        );

        return Translation::getInstance()->translateByString($label, $arguments);
    }

    /**
     * Label: 'X products have been deleted.'
     */
    public function translateLabelXProductsHaveBeenDeleted(array $arguments)
    {
        $label = $this->getLabelByRule(
            [
                'X product has been deleted.',
                'X products have been deleted.',
            ],
            $arguments['products']
        );

        return Translation::getInstance()->translateByString($label, $arguments);
    }

    /**
     * Label: 'X products have been deleted.'
     */
    public function translateLabelThisActionWillDeleteXProductsFromYourStore(array $arguments)
    {
        $label = $this->getLabelByRule(
            [
                'This action will delete X product from your store. Are you sure you want to continue?',
                'This action will delete X products from your store. Are you sure you want to continue?',
            ],
            $arguments['products']
        );

        return Translation::getInstance()->translateByString($label, $arguments);
    }
}
