/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Remove products controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

xcart.microhandlers.add(
  'RemoveProductsProgressHandler',
  '.remove-progress .bar',
  function () {
    jQuery(this)
      .bind(
        'error',
        function () {
          this.errorState = true;
          self.location = URLHandler.buildURL({
            'target': 'bulk_remove_products',
            'remove_failed': 1,
            'returnURL': window.location.href
          });
        }
      )
      .bind(
        'complete',
        function () {
          if (!this.errorState) {
            self.location = URLHandler.buildURL({
              'target': 'bulk_remove_products',
              'remove_completed': 1,
              'returnURL': window.location.href
            });
          }
        }
      ).bind(
      'cancel',
      function () {
        setTimeout(function () {
          window.location.reload();
        }, 1000);
      }
    );
  }
);
