/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Add address button controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function PopupButtonRemoveProducts(base) {
  PopupButtonRemoveProducts.superclass.constructor.apply(this, arguments);

  this.base.each(function () {
    this.setAttribute('data-without-close', '1');
  });
}

extend(PopupButtonRemoveProducts, PopupButton);

PopupButtonRemoveProducts.prototype.options = {
  width: 'auto',
  closeOnEscape: false,
  modal: true,
  dialogClass: 'bulk-remove__dialog'
};

PopupButtonRemoveProducts.prototype.pattern = '.popup-button.popup-remove-products';

decorate(
  'PopupButtonRemoveProducts',
  'eachClick',
  function (elem) {
    this.options.dialogClass = 'bulk-remove__dialog';

    document.querySelectorAll('.btn-group.btn-dropdown.dropup.open').forEach(
      (btnGroup) => {
        btnGroup.querySelector('button')?.click();
      }
    );

    return arguments.callee.previousMethod.apply(this, arguments);
  }
);

decorate(
  'PopupButtonRemoveProducts',
  'getURLParams',
  function (button) {
    let params = arguments.callee.previousMethod.apply(this, arguments);
    params.listWidget = button.form.querySelector('[name="itemsList"]')?.value;

    const selectedCheckboxes = button.form.querySelectorAll('input[type="checkbox"][name*="select["].selector:checked');
    let selectedCount = 0;

    selectedCheckboxes.forEach(
      (checkbox) => {
        const pId = checkbox.getAttribute('name').split('[')[1].split(']')[0];
        if (parseInt(pId)) {
          selectedCount++;
        }
      }
    );

    if (selectedCount > 0) {
      params.selectedCount = selectedCount;
    }

    return params;
  }
);

decorate(
  'PopupButtonRemoveProducts',
  'callback',
  function (selector) {
    arguments.callee.previousMethod.apply(this, arguments);
    xcart.autoload(PopupButton);
  }
);

decorate(
  'PopupButton',
  'callback',
  function (selector) {
    arguments.callee.previousMethod.apply(this, arguments);
    xcart.autoload(PopupButtonRemoveProducts);
  }
);

xcart.autoload(PopupButtonRemoveProducts);

xcart.microhandlers.add(
  'RemoveProductsHidePopupCloseButton',
  '.ajax-container-loadable.ctrl-xc-bulkediting-admin-bulkremoveproducts',
  function () {
    this.parentNode.querySelectorAll('.ui-dialog-titlebar-close').forEach(
      (btn) => {
        btn.classList.add('bulk-remove__close-btn');
      }
    );

    this.querySelectorAll('.event-task-progress').forEach(
      (block) => {
        new EventTaskProgress(jQuery(block));
      }
    );

    if (this.querySelector('.bulk-remove__text')) {
      const popupForm = this.querySelector('form');
      const selectedProductCheckboxes = document.querySelector('.popup-remove-products')
        ?.form
        ?.querySelectorAll('input[type="checkbox"][name*="select["].selector:checked');

      if (popupForm && selectedProductCheckboxes?.length) {
        selectedProductCheckboxes.forEach(
          (checkbox) => {
            let elem = document.createElement('INPUT');
            elem.setAttribute('type', 'hidden');
            elem.setAttribute('name', checkbox.getAttribute('name'));
            elem.setAttribute('value', '1');
            popupForm.appendChild(elem);
          }
        );
      }
    }
  }
);