<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\View\SearchPanel;

use XLite\View\FormField\Input\Text;
use XLite\View\FormField\Select\Product\AvailabilityStatus;
use XLite\View\Form\ItemsList\AItemsListSearch;
use XLite\View\SearchPanel\ASearchPanel;

class Brand extends ASearchPanel
{
    public const PARAM_SUBSTRING = 'substring';
    public const PARAM_ENABLED   = 'enabled';

    /**
     * Defines the form class.
     *
     * @return string
     */
    protected function getFormClass()
    {
        return AItemsListSearch::class;
    }

    protected function getLinkedItemsList()
    {
        return parent::getLinkedItemsList() . '.widget.items-list.qsl-shopbybrand-itemslist-model-brand';
    }

    protected function defineConditions()
    {
        return parent::defineConditions() + [
            self::PARAM_SUBSTRING => [
                static::CONDITION_CLASS => Text::class,
                Text::PARAM_FIELD_ONLY  => true,
                Text::PARAM_PLACEHOLDER => static::t('Search by brand'),
            ],
            self::PARAM_ENABLED => [
                static::CONDITION_CLASS              => AvailabilityStatus::class,
                AvailabilityStatus::PARAM_FIELD_ONLY => true,
            ],
        ];
    }
}
