<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\View\ItemsList\Model\Product\Admin;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Search extends \XLite\View\ItemsList\Model\Product\Admin\Search
{
    /**
     * Widget param names
     */
    public const PARAM_BRAND_ID = 'brandId';

    /**
     * Return search parameters.
     *
     * @return array
     */
    public static function getSearchParams()
    {
        return array_merge(
            parent::getSearchParams(),
            [
                static::PARAM_BRAND_ID    => [
                    'condition' => new \XLite\Model\SearchCondition\RepositoryHandler(\QSL\ShopByBrand\Model\Repo\Product::P_BRAND_ID),
                    'widget' => [
                        \XLite\View\SearchPanel\ASearchPanel::CONDITION_CLASS => 'QSL\ShopByBrand\View\FormField\Select\Product\Brand',
                        \XLite\View\FormField\AFormField::PARAM_LABEL => static::t('Brand'),
                        \XLite\View\SearchPanel\SimpleSearchPanel::CONDITION_TYPE => \XLite\View\SearchPanel\SimpleSearchPanel::CONDITION_TYPE_HIDDEN,
                    ],
                ],
            ]
        );
    }

    /**
     * Define columns structure
     *
     * @return array
     */
    protected function defineColumns()
    {
        $columns = parent::defineColumns();
        return array_merge(
            $columns,
            [
                'brandName' => [
                    static::COLUMN_NAME    => static::t('Brand'),
                    static::COLUMN_NO_WRAP => true,
                    static::COLUMN_ORDERBY => 300,
                ],
            ]
        );
    }
}
