<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\View\FormModel\Product;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;
use XLite\Core\Database;
use QSL\ShopByBrand\Main;
use QSL\ShopByBrand\Model\Brand;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

/**
 * @Extender\Mixin
 */
class Info extends \XLite\View\FormModel\Product\Info
{
    /**
     * If brand_id GET parameter is set, add it to the form action link.
     *
     * @return array
     */
    protected function getActionParams()
    {
        $result = parent::getActionParams();
        $brandId = (int) Request::getInstance()->brand_id;
        if ($brandId) {
            $result['brand_id'] = $brandId;
        }
        return $result;
    }

    protected function defineFields()
    {
        $schema = parent::defineFields();

        if (Main::isBrandAttributeSet()) {
            $brands = [];

            /** @var Brand $brand */
            foreach ((Database::getRepo(Brand::class)?->findAll() ?? []) as $brand) {
                $brands[$brand->getName()] = $brand->getId();
            }

            ksort($brands, SORT_STRING | SORT_FLAG_CASE);

            $schema[static::SECTION_DEFAULT]['brand'] = [
                'label'    => static::t('Brand'),
                'type'     => ChoiceType::class,
                'choices'  => $brands,
                'position' => 410,
            ];
        }

        return $schema;
    }
}
