<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\View\FormField\Select\Product;

use QSL\ShopByBrand\Model\Repo\Product as ProductRepo;
use QSL\ShopByBrand\Model\Repo\Brand as BrandRepo;
use XLite\Core\CommonCell;

/**
 * Brand selector.
 */
class Brand extends \QSL\ShopByBrand\View\FormField\Select\Brand
{
    /**
     * Return default options for the selector.
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        $list = [
            null                       => static::t('Any brand'),
            ProductRepo::P_BRAND_EMPTY => static::t('No brand assigned'),
        ];

        return $list + $this->getBrandList();
    }

    /**
     * Prepares the search condition for retrieving reminder templates.
     *
     * @return CommonCell
     */
    protected function getBrandSearchConditions()
    {
        return new CommonCell(
            [
                BrandRepo::SEARCH_ORDER_BY          => [BrandRepo::SORT_BY_BRAND_NAME, 'ASC'],
                BrandRepo::SEARCH_WITH_ANY_PRODUCTS => true,
            ]
        );
    }
}
