<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ShopByBrand\Transformer\XLite\Model\Product\Logic\Entity\Storefront;

use XCart\Transformer\QSL\ShopByBrand\Model\Brand\Logic\Entity\Storefront\BrandInterface as BrandTransformer;
use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductInterface;
use XLite\Model\Product as Source;
use XCart\Logic\Entity\Storefront\Product as Target;

class ProductDecorator implements ProductInterface
{
    public function __construct(
        private ProductInterface $inner,
        private BrandTransformer $brandTransformer
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        /** @var \QSL\ShopByBrand\Model\Brand $brand */
        $brand = $input->getBrand();

        if ($brand) {
            $target->setBrandName($brand->getName());
            $target->setBrand($this->brandTransformer->transform($brand));
        }

        return $target;
    }
}
