<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ShopByBrand\Transformer\QSL\ShopByBrand\Model\Brand\Logic\Entity\Storefront;

use QSL\ShopByBrand\Model\Brand as Source;
use XCart\Logic\Entity\Storefront\Brand as Target;
use XCart\Factory\Logic\Entity\Storefront\BrandInterface as Factory;
use XCart\Logic\Entity\Storefront\Image;
use XCart\Transformer\QSL\ShopByBrand\Model\Brand\Logic\Entity\Storefront\BrandInterface;

class BrandDecorator implements BrandInterface
{
    public function __construct(
        private BrandInterface $inner,
        private Factory $factory,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getId());
        $target->setName($input->getName());
        $target->setCleanUrl($input->getCleanURL());
        $target->setLogo(
            $this->getTransformedLogo($input)
        );

        $target->setDescription($input->getDescription());
        $target->setMetaTitle($input->getMetaTitle());
        $target->setMetaDescription($input->getMetaDescription());
        $target->setMetaTags($input->getMetaKeywords());

        return $target;
    }

    private function getTransformedLogo(Source $input): ?Image
    {
        if ($brandLogo = $input->getImage()) {
            return (new Image())
                ->setUrl($brandLogo->getFrontURL())
                ->setAlt($brandLogo->getAlt())
                ->setWidth($brandLogo->getWidth())
                ->setHeight($brandLogo->getHeight());
        }

        return null;
    }
}
