<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ShopByBrand;

use QSL\ShopByBrand\DependencyInjection\Compiler\AddProductFilterByBrandFieldPass;
use Symfony\Component\DependencyInjection\Compiler\PassConfig;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

final class ShopByBrandBundle extends Bundle
{
    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $container->addCompilerPass(new AddProductFilterByBrandFieldPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 710);
    }
}
