<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\Model\Repo\AttributeValue;

use XLite\Core\CommonCell;
use XLite\Model\Attribute;
use XLite\Model\Product;
use XCart\Extender\Mapping\Extender;

/**
 * Attribute values repository
 * @Extender\Mixin
 */
class AttributeValueSelect extends \XLite\Model\Repo\AttributeValue\AttributeValueSelect
{
    /**
     * Finds the AttributeValueSelect model for the product and the attribute.
     *
     * @param Product   $product   Product that we are looking the value for.
     * @param Attribute $attribute Attribute that we are looking the value for.
     *
     * @return \XLite\Model\AttributeValue\AttributeValueSelect|null
     */
    public function findProductAttributeValue(Product $product, Attribute $attribute)
    {
        return $this->findProductAttributeValues($product, $attribute)[0] ?? null;
    }

    /**
     * @return \XLite\Model\AttributeValue\AttributeValueSelect[]
     */
    public function findProductAttributeValues(Product $product, Attribute $attribute): array
    {
        $cnd = new CommonCell();

        $cnd->{static::SEARCH_PRODUCT}   = $product;
        $cnd->{static::SEARCH_ATTRIBUTE} = $attribute;

        $result = $this->search($cnd);

        return count($result) ? $result : [];
    }
}
