<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ShopByBrand\Model\Repo;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Database;
use XLite\Model\Attribute;

/**
 * @Extender\Mixin
 */
class AttributeOption extends \XLite\Model\Repo\AttributeOption
{
    public function getAttributeOptionBrandByName(string $name): ?\XLite\Model\AttributeOption
    {
        if ($attribute = Database::getRepo(Attribute::class)?->findBrandAttribute()) {
            return $this->findOneByNameAndAttribute($name, $attribute);
        }

        return null;
    }
}
