<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ShopByBrand\Logic\Export\Step;

use QSL\ShopByBrand\Model\Brand;
use QSL\ShopByBrand\Model\Repo\Brand as BrandRepository;
use XLite\Core\Database;
use XLite\Logic\Export\Step\Base\I18n;

class Brands extends I18n
{
    protected function getRepository(): BrandRepository
    {
        return Database::getRepo(Brand::class);
    }

    protected function getFilename(): string
    {
        return 'brands.csv';
    }

    protected function defineColumns(): array
    {
        $columns =  [
            'name'     => [],
            'image'    => [],
            'cleanURL' => [],
            'position' => [],
        ];

        $columns += $this->assignI18nColumns(
            [
                'description'     => [],
                'metaKeywords'    => [],
                'metaDescription' => [],
                'metaTitle'       => [],
            ]
        );

        return $columns;
    }

    protected function getNameColumnValue(array $dataset, string $name, int $i): string
    {
        return $dataset['model']->getName();
    }

    protected function getImageColumnValue(array $dataset, string $name, int $i): string
    {
        return $this->formatImageModel($dataset['model']->getImage());
    }

    protected function getCleanUrlColumnValue(array $dataset, string $name, int $i)
    {
        return $this->getColumnValueByName($dataset['model'], $name);
    }

    protected function getPositionColumnValue(array $dataset, string $name, int $i)
    {
        return $this->getColumnValueByName($dataset['model'], $name);
    }
}
