<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\Logic\Action\Storefront\Product\GetList\Resolver;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Resolver\FilterApplierResolverInterface;
use QSL\ShopByBrand\DataSource\Product\Applier\BrandApplier;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;

class BrandFilterApplierResolverDecorator implements FilterApplierResolverInterface
{
    public function __construct(
        private FilterApplierResolverInterface $inner,
        private ReadRepositoryInterface $brandRepository
    ) {
    }

    public function resolve(string $property, FilterValueInterface $value): ?ApplierInterface
    {
        if ($property === 'brandId') {
            return new BrandApplier($this->brandRepository);
        }

        return $this->inner->resolve($property, $value);
    }
}
