<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\Logic\Action\Storefront\Brand\GetList\Resolver;

use QSL\ShopByBrand\DataSource\Brand\Applier\FirstLetterApplier;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Resolver\FilterApplierResolverInterface;

class FirstLetterFilterApplierResolverDecorator implements FilterApplierResolverInterface
{
    public function __construct(
        private FilterApplierResolverInterface $inner
    ) {
    }

    public function resolve(string $property, FilterValueInterface $value): ?ApplierInterface
    {
        if ($property === 'firstLetter') {
            return new FirstLetterApplier();
        }

        return $this->inner->resolve($property, $value);
    }
}
