<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\Logic\Action\Storefront\Brand\Detailed\GetOneByCleanURL\Assembler;

use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\EntityId\EntityIdAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\IdBasedRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use QSL\ShopByBrand\Logic\Action\Storefront\Brand\Detailed\GetOneByCleanURL\DTO\Request;
use XLite\Model\Repo\CleanURL as CleanURLRepository;

class EntityIdAssembler implements EntityIdAssemblerInterface
{
    use LoggerAwareTrait;

    /**
     * @param CleanURLRepository $cleanURLRepository
     */
    public function __construct(
        private ReadRepositoryInterface $cleanURLRepository,
        LoggerInterface $logger,
    ) {
        $this->setLogger($logger);
    }

    /**
     * @param Request $request
     *
     * @return int
     */
    public function assemble(IdBasedRequestInterface|RequestInterface $request): int|string
    {
        $brandId = $this->cleanURLRepository->createQueryBuilder('entity')
            ->select('brand.brand_id')
            ->linkInner('entity.brand', 'brand')
            ->andWhere('entity.cleanURL = :cleanURL')
            ->setParameter('cleanURL', $request->getCleanURL())
            ->getSingleScalarResult();

        if (!$brandId) {
            $this->logger->error('Clean URL not associated with brand');

            return 0;
        }

        return (int) $brandId;
    }
}
