<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ShopByBrand\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;
use XLite\Core\Database;
use XLite\Model\Config as ConfigModel;

final class UpgradeTo551build3
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->changeConfigOptionCategory('default_brand_products_order', 'General', 'QSL\ShopByBrand');
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'QSL/ShopByBrand/resources/hooks/upgrade/5.5/1.3/upgrade.yaml');
    }

    private function changeConfigOptionCategory(string $optionName, string $oldOptionCategory, string $newOptionCategory): void
    {
        $configRepo = Database::getRepo(ConfigModel::class);
        $option = $configRepo?->findOneBy([
            'name'     => $optionName,
            'category' => $oldOptionCategory
        ]);

        if ($option) {
            $option->setCategory($newOptionCategory);
            Database::getEM()->flush();
        }
    }
}
