<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ShopByBrand\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;
use XLite\Core\Database;
use XLite\Model\ImageSettings;

final class UpgradeTo550build0
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->updateImageSettings();
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'QSL/ShopByBrand/resources/hooks/upgrade/5.5/0.0/upgrade.yaml');
    }

    private function updateImageSettings(): void
    {
        $imageSettingsList = Database::getRepo(ImageSettings::class)?->findByModuleName('QSL-ShopByBrand');

        if ($imageSettingsList) {
            foreach ($imageSettingsList as $imageSettings) {
                /** @var ImageSettings $imageSettings */
                $newModelValue = str_replace('XLite\\Module\\', '', $imageSettings->getModel());
                $imageSettings->setModel($newModelValue);
            }
        }
    }
}
